(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76437,       1618]
NotebookOptionsPosition[     73416,       1515]
NotebookOutlinePosition[     74025,       1537]
CellTagsIndexPosition[     73982,       1534]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z , external spherical diffusion",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}, {3.570533035842108*^9, 3.5705330403803673`*^9}, 
   3.5705382339774246`*^9, {3.570553977298891*^9, 3.570553984193285*^9}, {
   3.570796493918581*^9, 3.570796494859635*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.570533733413007*^9, 3.570533910188118*^9, 
   3.57053934340388*^9, 3.570555127082655*^9, 3.5705553201646986`*^9, 
   3.5705555073474045`*^9, 3.5705555648816957`*^9, 3.5705571982221174`*^9, 
   3.570557235474248*^9, 3.5705572710812845`*^9, 3.570557954506374*^9, {
   3.5705580936843348`*^9, 3.57055813259256*^9}, 3.5707965547220583`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Remove", "::", "rmnsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"There are no symbols matching \
\\\"\[NoBreak]\\!\\(\\\"Global`*\\\"\\)\[NoBreak]\\\". \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Remove/rmnsm\\\", \
ButtonNote -> \\\"Remove::rmnsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5707965549980745`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]", "=", 
  RowBox[{"R", "*", 
   RowBox[{"T", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["F", "2"], "*", "Co", "*", 
      RowBox[{"Sqrt", "[", "Dox", "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}, {3.5705330475077753`*^9, 
   3.5705331045800395`*^9}, 3.5705337217633405`*^9, {3.570533914131343*^9, 
   3.5705339276821184`*^9}, {3.5705383096987553`*^9, 3.570538399684902*^9}, {
   3.570538455217078*^9, 3.5705385242120247`*^9}, {3.5705385781811113`*^9, 
   3.5705386130431056`*^9}, {3.5705386973959303`*^9, 
   3.5705388328526783`*^9}, {3.5705388686457253`*^9, 
   3.5705388937151594`*^9}, {3.5705539935738215`*^9, 3.5705540484529605`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"]}]]], "Output",
 CellChangeTimes->{
  3.5705388964243145`*^9, 3.5705393435168867`*^9, 3.5705540511101127`*^9, 
   3.570555127196661*^9, 3.5705553203117065`*^9, 3.570555514380807*^9, 
   3.5705555650777063`*^9, 3.5705571983761263`*^9, 3.570557235591254*^9, 
   3.5705572711862907`*^9, 3.5705579546343813`*^9, {3.5705580938113422`*^9, 
   3.5705581327385683`*^9}, 3.5707965657976923`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zw", "=", 
  RowBox[{"2", "*", 
   RowBox[{"\[Sigma]", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"\[ImaginaryI]", "*", "\[Omega]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"Sqrt", "[", "Dox", "]"}], "/", "r0"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5705392072310915`*^9, 3.5705392132664366`*^9}, {
  3.5705540591705737`*^9, 3.5705543167563066`*^9}, {3.570555519555103*^9, 
  3.570555522548274*^9}, {3.570796514971785*^9, 3.570796546575593*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SqrtBox["Dox"], "r0"], "+", 
     SqrtBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.5705392149565334`*^9, 3.570539343543888*^9, 3.5705542143624496`*^9, {
   3.5705542553907967`*^9, 3.570554278495118*^9}, 3.5705543199654903`*^9, 
   3.570555127222663*^9, 3.57055532036771*^9, 3.5705555235353303`*^9, 
   3.57055556513371*^9, 3.5705571984211283`*^9, 3.570557235619256*^9, 
   3.5705572712172923`*^9, 3.570557954669383*^9, {3.570558093856344*^9, 
   3.570558132799572*^9}, 3.570796574837209*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zf", "=", 
  RowBox[{"Rct", "+", "Zw"}]}]], "Input",
 CellChangeTimes->{{3.5705543548144836`*^9, 3.5705543616518745`*^9}}],

Cell[BoxData[
 RowBox[{"Rct", "+", 
  FractionBox[
   RowBox[{"2", " ", "R", " ", "T"}], 
   RowBox[{"Co", " ", 
    SqrtBox["Dox"], " ", 
    SuperscriptBox["F", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SqrtBox["Dox"], "r0"], "+", 
      SqrtBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.570554363002952*^9, 3.5705551272456636`*^9, 3.5705553204257135`*^9, 
   3.57055552685052*^9, 3.5705555651917133`*^9, 3.5705571984721317`*^9, 
   3.5705572356532583`*^9, 3.570557271260295*^9, 3.570557954715386*^9, {
   3.5705580938923464`*^9, 3.570558132861575*^9}, 3.570796595635399*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z", "=", 
  RowBox[{"Rs", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "Zf"}], "+", 
      RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "Cdl"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.570554375573671*^9, 3.5705544213962917`*^9}}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox[
       RowBox[{"2", " ", "R", " ", "T"}], 
       RowBox[{"Co", " ", 
        SqrtBox["Dox"], " ", 
        SuperscriptBox["F", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SqrtBox["Dox"], "r0"], "+", 
          SqrtBox[
           RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], "+", 
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}]], "Output",
 CellChangeTimes->{3.570796818595151*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\[AliasDelimiter]"], "Input",
 CellChangeTimes->{3.5707967567316127`*^9}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox[
       RowBox[{"R", " ", "T"}], 
       RowBox[{"Co", " ", 
        SqrtBox["Dox"], " ", 
        SuperscriptBox["F", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            SqrtBox["Dox"], "r0"]}], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
           RowBox[{"Coth", "[", 
            RowBox[{"r0", " ", 
             SqrtBox[
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
            "]"}]}]}], ")"}]}]]}]]}]]}]], "Output",
 CellChangeTimes->{
  3.5705544238674335`*^9, 3.570555127297667*^9, 3.5705553204827166`*^9, 
   3.5705555291666527`*^9, 3.570555565250716*^9, 3.570557198519134*^9, 
   3.5705572356792593`*^9, 3.570557271289296*^9, 3.5705579547543883`*^9, {
   3.5705580939383492`*^9, 3.5705581329195786`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.5705544366851664`*^9, 3.570554446386721*^9}}],

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"2", " ", "R", " ", "T"}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            SqrtBox["Dox"], "r0"], "+", 
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.570554447671795*^9, 3.5705551273266687`*^9, 3.57055532054072*^9, 
   3.5705555653087196`*^9, 3.5705568274239087`*^9, 3.5705571985761375`*^9, 
   3.570557235721262*^9, 3.570557271341299*^9, 3.5705579548053913`*^9, {
   3.5705580939923525`*^9, 3.570558132978582*^9}, 3.5707968342810483`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z2", "=", 
  RowBox[{"Im", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.570554449777915*^9, 3.5705544568673205`*^9}}],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"2", " ", "R", " ", "T"}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            SqrtBox["Dox"], "r0"], "+", 
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.5705544587714295`*^9, 3.570555127376672*^9, 3.5705553206007233`*^9, 
   3.570555565362723*^9, 3.5705568312251263`*^9, 3.5705571986381407`*^9, 
   3.570557235754264*^9, 3.5705572713763013`*^9, 3.5705579548483934`*^9, {
   3.5705580940273542`*^9, 3.5705581330375853`*^9}, 3.5707968400143766`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ZM", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Z1", "^", "2"}], "+", 
    RowBox[{"Z2", "^", "2"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"lZM", "=", 
  RowBox[{"Log10", "[", "ZM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5705544727082267`*^9, 3.5705544926593676`*^9}, {
  3.570554806084295*^9, 3.5705548115736084`*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"2", " ", "R", " ", "T"}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               SqrtBox["Dox"], "r0"], "+", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], 
        "+", 
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], "]"}], 
    "2"], "+", 
   SuperscriptBox[
    RowBox[{"Re", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"2", " ", "R", " ", "T"}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               SqrtBox["Dox"], "r0"], "+", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], 
        "+", 
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], "]"}], 
    "2"]}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842648527*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Im", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"2", " ", "R", " ", "T"}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                FractionBox[
                 SqrtBox["Dox"], "r0"], "+", 
                SqrtBox[
                 RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], 
          "+", 
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], "]"}], 
      "2"], "+", 
     SuperscriptBox[
      RowBox[{"Re", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"2", " ", "R", " ", "T"}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                FractionBox[
                 SqrtBox["Dox"], "r0"], "+", 
                SqrtBox[
                 RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}]]}]], 
          "+", 
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], "]"}], 
      "2"]}]], "]"}], 
  RowBox[{"Log", "[", "10", "]"}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842652527*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{"10", "^", "lom"}]}]], "Input",
 CellChangeTimes->{{3.5705545122914906`*^9, 3.5705545204389567`*^9}}],

Cell[BoxData[
 SuperscriptBox["10", "lom"]], "Output",
 CellChangeTimes->{
  3.570554521526019*^9, 3.570555127457676*^9, 3.5705553207367315`*^9, 
   3.570555565496731*^9, 3.570557198785149*^9, 3.570557235825268*^9, 
   3.5705572714463053`*^9, 3.570557954939399*^9, {3.5705580941353607`*^9, 
   3.570558133168593*^9}, 3.570796845715702*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rs", "=", "10"}], "\[IndentingNewLine]", 
 RowBox[{"Rct", "=", "50"}], "\[IndentingNewLine]", 
 RowBox[{"Cdl", "=", 
  RowBox[{"20", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Dox", "=", 
  RowBox[{"1", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Co", "=", 
  RowBox[{"2", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"r0", "=", "0.01"}], "\[IndentingNewLine]", 
 RowBox[{"F", "=", "96485"}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", "298.15"}], "\[IndentingNewLine]", 
 RowBox[{"R", "=", "8.31447"}]}], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
   3.5218880815430183`*^9, 3.5218880856382523`*^9}, {3.5705331185628395`*^9, 
   3.570533164322457*^9}, {3.5705389117301893`*^9, 3.570538957625815*^9}, {
   3.5705545315715933`*^9, 3.5705545321316257`*^9}, {3.5705546440840287`*^9, 
   3.570554744162753*^9}, {3.570555291317048*^9, 3.5705552918600793`*^9}, {
   3.570558088948064*^9, 3.57055814814845*^9}, 3.5707968842859087`*^9}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.5707968884541473`*^9}],

Cell[BoxData[
 FractionBox["1", "50000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888456147*^9}],

Cell[BoxData[
 FractionBox["1", "100000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888458147*^9}],

Cell[BoxData[
 FractionBox["1", "500000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888467148*^9}],

Cell[BoxData["0.01`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888470148*^9}],

Cell[BoxData["96485"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888472148*^9}],

Cell[BoxData["298.15`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.5707968884741483`*^9}],

Cell[BoxData["8.31447`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888484149*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "7"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, {3.5705338870747957`*^9, 
   3.570533898082425*^9}, {3.5705339800831156`*^9, 3.570534005494569*^9}, 
   3.570539142100366*^9, {3.570554838147128*^9, 3.5705548545010643`*^9}, 
   3.5705548849028025`*^9, {3.570796901071869*^9, 3.5707969015338955`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8lF8XAHDJFpWtopJ1jF3JOtZjZ8YyY49kZ+wp9aOdUCmyV8oSFSVl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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 326.0985947462356}, {-55.210849368729875`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5705572359982777`*^9, 3.570557271602314*^9, 3.5705579551504107`*^9, {
   3.5705580943653736`*^9, 3.5705581333856053`*^9}, {3.570796892456376*^9, 
   3.570796904154045*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5705572046414843`*^9, 3.5705572046984873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "Zf", "]"}], ",", 
     RowBox[{"Im", "[", "Zf", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.570554936758769*^9, 3.57055496859659*^9}, {
  3.5707969178858304`*^9, 3.5707969214870367`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1XlYTV0XAPDQIDTRoExdJG+FJN7yitV4u/c0SgMNt+EOzd0GFJo0ShlC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     "]]}},
  Axes->True,
  AxesOrigin->{50., 0},
  Method->{},
  PlotRange->{{50.059543552317116`, 310.3382260132863}, {-55.14979127194297, 
   0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236051281*^9, 3.570557271666318*^9, 3.570557955226415*^9, {
   3.5705580944143763`*^9, 3.5705581334366083`*^9}, 3.570796923273138*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.570557207026621*^9, 3.5705572070806236`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Z2", "/", "Z1"}], "]"}], "*", 
   RowBox[{"180", "/", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}, {
  3.5705340884983163`*^9, 3.5705341365780663`*^9}, {3.5705342253151417`*^9, 
  3.570534229010353*^9}, {3.570535226003378*^9, 3.5705352276364717`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"180", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Im", "[", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "lom"}]], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"50", "+", 
          FractionBox["84.20730765570659`", 
           RowBox[{"0.31622776601683794`", "\[VeryThinSpace]", "+", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]}]]}]]}]], "]"}], 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["84.20730765570659`", 
            RowBox[{"0.31622776601683794`", "\[VeryThinSpace]", "+", 
             SqrtBox[
              RowBox[{"\[ImaginaryI]", " ", 
               SuperscriptBox["10", "lom"]}]]}]]}]]}]], "]"}]}]], "]"}]}], 
  "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.5705341416623573`*^9, 3.5705342311404753`*^9, 3.570535231352684*^9, 
   3.570539161852496*^9, 3.570539343825904*^9, 3.57055489307027*^9, 
   3.570555127712691*^9, 3.5705553209927454`*^9, 3.5705555658767524`*^9, 
   3.570557199095167*^9, 3.5705572360782824`*^9, 3.5705572716983194`*^9, 
   3.570557955257417*^9, {3.570558094444378*^9, 3.57055813346661*^9}, 
   3.5707969350128098`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5705341597473917`*^9, 3.5705341793945155`*^9}, 3.570555008228857*^9, 
   3.5707969433742886`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwlmnk4Vd/3x83DveY5ZbzIEHFRIZ1tummkDEmzFFFCKkVIpkYSlSGhkgwp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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-4., 6.}, {-45.99593076369293, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236110284*^9, 3.570557271809326*^9, 3.5705579553724236`*^9, {
   3.570558094558385*^9, 3.570558133580617*^9}, 3.570796945274397*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "lZM"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5707969728999767`*^9, 3.570797001887635*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk0Vd8XAHBv4Jm9wXsPlQyRZmQqcnZmikoIaUKFylAaRKKJBikUlUQl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     "]]}},
  Axes->True,
  AxesOrigin->{0, 1.},
  Method->{},
  PlotRange->{{-4., 6.}, {1.0000075974089677`, 2.505677358353379}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5707970045507874`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lom", ",", "Z1", ",", "Z2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lom", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9, {3.570535356419838*^9, 
   3.570535388915696*^9}, 3.5705394635877542`*^9, {3.57053949726768*^9, 
   3.57053949778371*^9}, {3.570539586787801*^9, 3.570539603699768*^9}, 
   3.5705397446258287`*^9, 3.5707970178545485`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<spherext-Mat.txt\>\"", ",", "res", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}, {
   3.570535395572077*^9, 3.5705353973291774`*^9}, {3.570539502739993*^9, 
   3.570539506052183*^9}, 3.57053956107633*^9, {3.570539655171712*^9, 
   3.570539663507189*^9}, 3.5705397519122453`*^9, {3.570555063732031*^9, 
   3.5705550730595646`*^9}, {3.5707970342074833`*^9, 3.570797034910524*^9}}],

Cell[BoxData["\<\"spherext-Mat.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5705354057616596`*^9, 
   3.570539344568947*^9, 3.570539511388488*^9, 3.570539566442637*^9, 
   3.57053967402779*^9, 3.570539755160431*^9, 3.570539785664176*^9, 
   3.5705550796219397`*^9, 3.5705551278827004`*^9, 3.5705553211777563`*^9, 
   3.5705555661347675`*^9, 3.5705571992251744`*^9, 3.5705572361762877`*^9, 
   3.5705572718723297`*^9, 3.5705579554434276`*^9, {3.570558094625388*^9, 
   3.5705581336466208`*^9}, 3.570797038781745*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.6000001430511475`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 695, 14, 186, "Title"],
Cell[CellGroupData[{
Cell[1287, 40, 589, 10, 164, "Input"],
Cell[1879, 52, 1510, 21, 47, "Output"],
Cell[3392, 75, 468, 10, 37, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3897, 90, 1844, 29, 54, "Input"],
Cell[5744, 121, 516, 11, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6297, 137, 521, 12, 47, "Input"],
Cell[6821, 151, 751, 18, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7609, 174, 146, 3, 47, "Input"],
Cell[7758, 179, 665, 17, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8460, 201, 308, 9, 47, "Input"],
Cell[8771, 212, 590, 18, 113, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9398, 235, 87, 1, 47, "Input"],
Cell[9488, 238, 1092, 30, 124, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10617, 273, 147, 3, 47, "Input"],
Cell[10767, 278, 910, 24, 113, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11714, 307, 147, 3, 47, "Input"],
Cell[11864, 312, 915, 24, 113, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12816, 341, 365, 9, 77, "Input"],
Cell[13184, 352, 1693, 49, 127, "Output"],
Cell[14880, 403, 1862, 52, 146, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16779, 460, 152, 3, 47, "Input"],
Cell[16934, 465, 339, 6, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17310, 476, 1134, 24, 280, "Input"],
Cell[18447, 502, 416, 6, 47, "Output"],
Cell[18866, 510, 418, 6, 47, "Output"],
Cell[19287, 518, 439, 7, 66, "Output"],
Cell[19729, 527, 440, 7, 66, "Output"],
Cell[20172, 536, 440, 7, 66, "Output"],
Cell[20615, 545, 419, 6, 47, "Output"],
Cell[21037, 553, 419, 6, 47, "Output"],
Cell[21459, 561, 423, 6, 47, "Output"],
Cell[21885, 569, 422, 6, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22344, 580, 1393, 23, 47, "Input"],
Cell[23740, 605, 12503, 212, 127, "Output"]
}, Open  ]],
Cell[36258, 820, 96, 1, 47, "Input"],
Cell[CellGroupData[{
Cell[36379, 825, 405, 11, 47, "Input"],
Cell[36787, 838, 5835, 103, 150, "Output"]
}, Open  ]],
Cell[42637, 944, 94, 1, 47, "Input"],
Cell[CellGroupData[{
Cell[42756, 949, 395, 8, 47, "Input"],
Cell[43154, 959, 1790, 47, 185, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44981, 1011, 936, 17, 47, "Input"],
Cell[45920, 1030, 14287, 241, 715, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60244, 1276, 293, 8, 47, "Input"],
Cell[60540, 1286, 9468, 162, 136, "Output"]
}, Open  ]],
Cell[70023, 1451, 1163, 22, 47, "Input"],
Cell[CellGroupData[{
Cell[71211, 1477, 598, 10, 47, "Input"],
Cell[71812, 1489, 1576, 22, 104, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
